/****** Object:  UserDefinedFunction [dbo].[fn_replace_chars_regex]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_replace_chars_regex]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'Create Function [dbo].[fn_replace_chars_regex](@Temp VarChar(1000), @p_ValidChars nvarchar(50))
Returns nvarchar(1000)
AS
Begin

    Declare @KeepValues as nvarchar(50)
    Set @KeepValues = ''%''+ @p_ValidChars +''%''
    While PatIndex(@KeepValues, @Temp) > 0
        Set @Temp = Stuff(@Temp, PatIndex(@KeepValues, @Temp), 1, '''')

    Return @Temp
End' 
END

GO
/****** Object:  Table [dbo].[catavolt_notification]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[catavolt_notification]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[catavolt_notification](
	[serial_key] [bigint] IDENTITY(1,1) NOT NULL,
	[notification_type] [nvarchar](40) NULL,
	[notification_userid] [nvarchar](255) NULL,
	[notification_groupid] [nvarchar](128) NULL,
	[notification_title] [nvarchar](255) NULL,
	[notification_body] [nvarchar](max) NULL,
	[notification_body_formatted] [nvarchar](max) NULL,
	[notification_status] [nvarchar](40) NOT NULL,
	[notification_from_email] [nvarchar](255) NULL,
	[badge_update_only] [nvarchar](1) NOT NULL,
	[manual_completion] [nvarchar](1) NOT NULL,
	[processed_by_node] [nvarchar](10) NULL,
	[num_retries] [int] NOT NULL,
	[last_attempt] [datetime2](7) NULL,
	[attachment_list] [varchar](8000) NULL,
	[userdata1] [nvarchar](255) NULL,
	[userdata2] [nvarchar](255) NULL,
	[userdata3] [nvarchar](255) NULL,
	[userdata4] [nvarchar](255) NULL,
	[userdata5] [nvarchar](255) NULL,
	[userdata6] [nvarchar](255) NULL,
	[userdata7] [nvarchar](255) NULL,
	[userdata8] [nvarchar](255) NULL,
	[userdata9] [nvarchar](255) NULL,
	[userdata10] [nvarchar](255) NULL,
	[userdata11] [nvarchar](255) NULL,
	[userdata12] [nvarchar](255) NULL,
	[userdata13] [nvarchar](255) NULL,
	[userdata14] [nvarchar](255) NULL,
	[userdata15] [nvarchar](255) NULL,
	[userdata16] [nvarchar](255) NULL,
	[userdata17] [nvarchar](255) NULL,
	[userdata18] [nvarchar](255) NULL,
	[userdata19] [nvarchar](255) NULL,
	[userdata20] [nvarchar](255) NULL,
	[longuserdata1] [nvarchar](max) NULL,
	[longuserdata2] [nvarchar](max) NULL,
	[longuserdata3] [nvarchar](max) NULL,
	[longuserdata4] [nvarchar](max) NULL,
	[longuserdata5] [nvarchar](max) NULL,
	[longuserdata6] [nvarchar](max) NULL,
	[longuserdata7] [nvarchar](max) NULL,
	[longuserdata8] [nvarchar](max) NULL,
	[longuserdata9] [nvarchar](max) NULL,
	[longuserdata10] [nvarchar](max) NULL,
	[longuserdata11] [nvarchar](max) NULL,
	[longuserdata12] [nvarchar](max) NULL,
	[longuserdata13] [nvarchar](max) NULL,
	[longuserdata14] [nvarchar](max) NULL,
	[longuserdata15] [nvarchar](max) NULL,
	[longuserdata16] [nvarchar](max) NULL,
	[longuserdata17] [nvarchar](max) NULL,
	[longuserdata18] [nvarchar](max) NULL,
	[longuserdata19] [nvarchar](max) NULL,
	[longuserdata20] [nvarchar](max) NULL,
 CONSTRAINT [catavolt_notification_pkey] PRIMARY KEY CLUSTERED 
(
	[serial_key] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[catavolt_notification_group]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[catavolt_notification_group]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[catavolt_notification_group](
	[groupid] [nvarchar](128) NOT NULL,
	[group_name] [nvarchar](255) NULL,
 CONSTRAINT [catavolt_notification_group_pkey] PRIMARY KEY CLUSTERED 
(
	[groupid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[catavolt_notification_group_user]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[catavolt_notification_group_user]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[catavolt_notification_group_user](
	[groupid] [nvarchar](128) NOT NULL,
	[userid] [nvarchar](255) NOT NULL,
	[user_name] [nvarchar](255) NULL,
	[user_status] [nvarchar](1) NOT NULL,
 CONSTRAINT [catavolt_notification_group_user_pkey] PRIMARY KEY CLUSTERED 
(
	[groupid] ASC,
	[userid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[catavolt_notification_method]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[catavolt_notification_method]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[catavolt_notification_method](
	[serial_key] [int] IDENTITY(1,1) NOT NULL,
	[notification_userid] [nvarchar](255) NOT NULL,
	[notification_method] [nvarchar](40) NULL,
	[method_address] [nvarchar](255) NULL,
	[address_description] [nvarchar](255) NULL,
	[method_status] [nvarchar](1) NOT NULL,
	[device_type] [nvarchar](40) NULL,
 CONSTRAINT [catavolt_notification_method_pkey] PRIMARY KEY CLUSTERED 
(
	[serial_key] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[dummy_table]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[dummy_table]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[dummy_table](
	[rec_id] [int] NOT NULL,
 CONSTRAINT [pk_dummy_table] PRIMARY KEY CLUSTERED 
(
	[rec_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_account]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_account]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_account](
	[account_id] [int] IDENTITY(1,1) NOT NULL,
	[account_number] [int] NULL,
	[account_desc] [varchar](80) NULL,
	[is_active] [bit] NOT NULL,
	[ledger_number] [int] NULL,
	[group_number] [int] NULL,
 CONSTRAINT [PK__xalt_acc__46A222CD7B3F16D7] PRIMARY KEY CLUSTERED 
(
	[account_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_accounting_class]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_accounting_class]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_accounting_class](
	[acct_class_id] [int] IDENTITY(1,1) NOT NULL,
	[acct_class_desc] [nvarchar](80) NULL,
	[is_active] [bit] NOT NULL,
 CONSTRAINT [PK__xalt_acc__D562B8F44EB33094] PRIMARY KEY CLUSTERED 
(
	[acct_class_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_exchange_rates]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_exchange_rates]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_exchange_rates](
	[rate_id] [int] IDENTITY(1,1) NOT NULL,
	[curr_from] [nvarchar](3) NULL,
	[curr_to] [nvarchar](3) NULL,
	[active_from] [date] NOT NULL,
	[active_to] [date] NOT NULL,
	[rate_value] [numeric](12, 7) NULL,
 CONSTRAINT [PK__expense___75920B42E5353DB8] PRIMARY KEY CLUSTERED 
(
	[rate_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_favorite]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_favorite]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_favorite](
	[fav_id] [int] IDENTITY(1,1) NOT NULL,
	[exp_line_desc] [nvarchar](80) NOT NULL,
	[user_id] [nvarchar](40) NOT NULL,
	[day_of_month] [int] NOT NULL,
	[fixed_amount] [int] NOT NULL,
	[currency_code] [nvarchar](3) NULL,
	[local_amount] [numeric](12, 2) NULL,
	[is_billable] [int] NOT NULL,
	[client_id] [int] NOT NULL,
	[project_id] [int] NOT NULL,
	[exp_type] [nvarchar](2) NULL,
	[account_id] [int] NULL,
	[is_active] [int] NOT NULL,
 CONSTRAINT [pk_expense_favorites] PRIMARY KEY CLUSTERED 
(
	[fav_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_header]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_header]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_header](
	[exp_header_id] [int] IDENTITY(1,1) NOT NULL,
	[exp_header_desc] [nvarchar](80) NULL,
	[exp_user_id] [nvarchar](40) NULL,
	[exp_month] [int] NULL,
	[exp_year] [int] NULL,
	[created_date] [date] NULL,
	[exp_status_id] [int] NULL,
	[approved_date] [date] NULL,
	[pay_date] [date] NULL,
	[exp_text] [nvarchar](4000) NULL,
	[approver_user_id] [nvarchar](40) NULL,
	[attach_count] [numeric](12, 0) NULL,
	[is_extracted] [bit] NULL,
	[extracted_date] [date] NULL,
	[paid_date] [date] NULL,
	[extracter_user_id] [nvarchar](40) NULL,
	[payer_user_id] [nvarchar](40) NULL,
	[is_paid] [bit] NULL,
	[rejected_date] [date] NULL,
	[submit_date] [date] NULL,
	[qb_is_entered] [bit] NOT NULL,
	[qb_status_id] [int] NULL,
	[qb_payroll_date_id] [int] NULL,
	[is_invoiced] [bit] NOT NULL,
	[invoice_number] [nvarchar](20) NULL,
 CONSTRAINT [PK__expense___EE88AF48B8C9DDBD] PRIMARY KEY CLUSTERED 
(
	[exp_header_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_line]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_line]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_line](
	[exp_line_id] [int] IDENTITY(1,1) NOT NULL,
	[exp_header_id] [int] NOT NULL,
	[exp_line_desc] [nvarchar](80) NULL,
	[exp_line_date] [date] NULL,
	[created_user_id] [nvarchar](40) NULL,
	[currency_code] [varchar](3) NULL,
	[local_amount] [numeric](12, 2) NULL,
	[created_date] [date] NULL,
	[is_billable] [bit] NOT NULL,
	[client_id] [int] NULL,
	[project_id] [int] NULL,
	[exp_type] [varchar](2) NULL,
	[account_id] [int] NULL,
	[attach_count] [numeric](12, 0) NULL,
	[is_favorite] [bit] NOT NULL,
	[favorite_id] [int] NULL,
	[accounting_class_override] [int] NULL,
 CONSTRAINT [PK_expense_line] PRIMARY KEY CLUSTERED 
(
	[exp_line_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_month]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_month]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_month](
	[month_val] [int] NOT NULL,
	[month_name] [nvarchar](15) NULL,
	[month_abbr] [nvarchar](3) NULL,
 CONSTRAINT [PK__expense___2205F1B1AD6F35E0] PRIMARY KEY CLUSTERED 
(
	[month_val] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_payroll_period]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_payroll_period]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_payroll_period](
	[payroll_period_id] [int] IDENTITY(1,1) NOT NULL,
	[payroll_period_date] [date] NOT NULL,
 CONSTRAINT [PK__expense___CD8483A287E0D980] PRIMARY KEY CLUSTERED 
(
	[payroll_period_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_qb_status]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_qb_status]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_qb_status](
	[qb_status_id] [int] IDENTITY(1,1) NOT NULL,
	[qb_status_desc] [nvarchar](80) NULL,
 CONSTRAINT [PK__expense___7D0BC07717FEC3C1] PRIMARY KEY CLUSTERED 
(
	[qb_status_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_status]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_status]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_status](
	[exp_status_id] [int] IDENTITY(1,1) NOT NULL,
	[exp_status_desc] [nvarchar](80) NULL,
	[allow_edit] [bit] NOT NULL,
	[allow_submit] [bit] NOT NULL,
 CONSTRAINT [PK__expense___3683B531A66085E7] PRIMARY KEY CLUSTERED 
(
	[exp_status_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[expense_year]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[expense_year]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[expense_year](
	[year_val] [int] NOT NULL,
	[is_active] [bit] NULL,
 CONSTRAINT [PK__expense___9F8BC29CCEDE6EE2] PRIMARY KEY CLUSTERED 
(
	[year_val] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[xalt_client]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[xalt_client]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[xalt_client](
	[client_id] [int] IDENTITY(1,1) NOT NULL,
	[client_desc] [nvarchar](80) NULL,
	[in_internal] [int] NOT NULL,
 CONSTRAINT [pk_client] PRIMARY KEY CLUSTERED 
(
	[client_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[xalt_employee]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[xalt_employee]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[xalt_employee](
	[employee_id] [int] IDENTITY(1,1) NOT NULL,
	[last_name] [nvarchar](50) NOT NULL,
	[first_name] [nvarchar](50) NOT NULL,
	[full_name]  AS (([first_name]+' ')+[last_name]),
	[is_active] [bit] NOT NULL,
	[is_full_time] [bit] NOT NULL,
	[is_internal] [bit] NOT NULL,
	[available_percent] [numeric](12, 2) NULL,
	[extender_user_id] [nvarchar](80) NULL,
	[manager_employee_id] [int] NULL,
	[emp_email] [nvarchar](150) NULL,
	[is_manager] [bit] NOT NULL,
	[emp_type_id] [int] NULL,
	[emp_role_id] [int] NULL,
	[accounting_class_id] [int] NULL,
	[external_emp_id] [int] NULL,
	[rr_ratio] [int] NULL,
 CONSTRAINT [PK__xalt_emp__C52E0BA8E23AEB69] PRIMARY KEY CLUSTERED 
(
	[employee_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[xalt_employee_role]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[xalt_employee_role]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[xalt_employee_role](
	[emp_role_id] [int] IDENTITY(1,1) NOT NULL,
	[emp_role_desc] [nvarchar](50) NULL,
 CONSTRAINT [PK__xalt_emp__5AF9E66C3512B02C] PRIMARY KEY CLUSTERED 
(
	[emp_role_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[xalt_employee_type]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[xalt_employee_type]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[xalt_employee_type](
	[emp_type_id] [int] IDENTITY(1,1) NOT NULL,
	[emp_type_desc] [nvarchar](50) NULL,
 CONSTRAINT [PK__xalt_emp__2FEB5F05B21A4526] PRIMARY KEY CLUSTERED 
(
	[emp_type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[xalt_project]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[xalt_project]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[xalt_project](
	[project_id] [int] IDENTITY(1,1) NOT NULL,
	[project_desc] [nvarchar](80) NULL,
	[project_type] [nvarchar](10) NULL,
	[is_internal] [int] NOT NULL,
	[billing_type] [int] NOT NULL,
	[total_billable_hours] [decimal](12, 2) NOT NULL,
	[this_month_billable_hours] [decimal](12, 2) NOT NULL,
	[quoted_hours] [decimal](12, 2) NOT NULL,
	[quoted_cost] [decimal](12, 2) NOT NULL,
	[hourly_rate] [decimal](12, 2) NOT NULL,
	[client_id] [int] NULL,
	[service_order] [nvarchar](20) NULL,
	[project_status_id] [int] NOT NULL,
	[estimate_start_date] [date] NULL,
	[estimate_end_date] [date] NULL,
	[estimate_date_end] [date] NULL,
	[primary_resource_id] [int] NULL,
 CONSTRAINT [pk_project] PRIMARY KEY CLUSTERED 
(
	[project_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[employee_document_conversation]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[employee_document_conversation]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[employee_document_conversation](
	[doc_key] [int] IDENTITY(1,1) NOT NULL,
	[doc_type] [varchar](150) NOT NULL,
	[doc_fk] [varchar](150) NOT NULL,
	[doc_created] [datetime2](6) NOT NULL,
	[doc_status] [varchar](150) NOT NULL,
	[doc_converted] [datetime2](6) NULL,
	[doc_conversion_attempts] [int] NULL,
	[doc_email_address] [varchar](150) NOT NULL,
	[doc_email_address_from] [varchar](150) NULL,
	[doc_email_subject] [varchar](150) NULL,
	[doc_email_body] [varchar](max) NULL,
	[doc_email_attachment] [varchar](max) NULL,
	[doc_email_from] [varchar](150) NULL,
 CONSTRAINT [PK__employee__763C081507FE3C21] PRIMARY KEY CLUSTERED 
(
	[doc_key] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
/****** Object:  View [dbo].[expense_currency_codes_vw]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[expense_currency_codes_vw]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[expense_currency_codes_vw] AS 
 SELECT DISTINCT expense_exchange_rates.curr_from
   FROM expense_exchange_rates;



' 
GO
/****** Object:  View [dbo].[expense_favorite_logicals_vw]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[expense_favorite_logicals_vw]'))
EXEC dbo.sp_executesql @statement = N'



create view [dbo].[expense_favorite_logicals_vw]
as
select 
	expense_favorite.fav_id
	,max(expense_line.exp_line_date) as last_expensed_date
from 
	expense_favorite
	left join expense_line  
		on expense_favorite.fav_id = expense_line.favorite_id
group by 
	expense_favorite.fav_id
' 
GO
/****** Object:  View [dbo].[expense_header_logicals_vw]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[expense_header_logicals_vw]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[expense_header_logicals_vw] AS
 SELECT 
	expense_header.exp_header_id
	,employee.employee_id 
    ,employee.full_name as employee_name
	,manager.employee_id AS manager_employee_id
    ,manager.full_name AS manager_name
    ,manager.extender_user_id AS manager_extender_user_id
	,coalesce(linesums.total_value_usd,0) as total_value_usd
	,coalesce(linesums.line_count,0) as line_count
   FROM 
	expense_header
	LEFT JOIN xalt_employee employee
		on (expense_header.exp_user_id = employee.extender_user_id)
	LEFT JOIN xalt_employee manager
		ON (employee.manager_employee_id = manager.employee_id)
	left join (
		SELECT exp_header_id
			,SUM(expense_line.local_amount * expense_exchange_rates.rate_value) as total_value_usd
			,count(*) as line_count
		FROM expense_line expense_line 
		LEFT OUTER JOIN expense_exchange_rates  
			ON  (expense_line.exp_line_date <= expense_exchange_rates.active_to 
				AND expense_line.created_date >= expense_exchange_rates.active_from 
				AND ''USD'' = expense_exchange_rates.curr_to 
				AND expense_line.currency_code = expense_exchange_rates.curr_from) 
		group by exp_header_id
		) linesums on expense_header.exp_header_id = linesums.exp_header_id
	
' 
GO
/****** Object:  View [dbo].[expense_line_summary_vw]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[expense_line_summary_vw]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[expense_line_summary_vw] AS 
	SELECT 
		expense_line.exp_header_id
		,expense_line.created_user_id
		,expense_line.account_id
		,sum(expense_line.local_amount * b.rate_value) AS account_amount
	FROM expense_line 
	JOIN dbo.expense_exchange_rates b 
		ON 
			expense_line.currency_code = b.curr_from 
			AND expense_line.exp_line_date < b.active_to 
			AND expense_line.exp_line_date>= b.active_from 
			AND b.curr_to = ''USD''
	GROUP BY 
		expense_line.exp_header_id
		,expense_line.created_user_id
		,expense_line.account_id
UNION 
	SELECT 
		expense_header.exp_header_id
		,'''' userid
		, 0 AS account
		,''NULL'' AS account_amount
	FROM expense_header
' 
GO
SET ANSI_PADDING ON

GO
/****** Object:  Index [ix_expense_exchange_rate_to_usd]    Script Date: 1/15/2019 8:16:16 PM ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[expense_exchange_rates]') AND name = N'ix_expense_exchange_rate_to_usd')
CREATE NONCLUSTERED INDEX [ix_expense_exchange_rate_to_usd] ON [dbo].[expense_exchange_rates]
(
	[active_to] DESC,
	[active_from] DESC,
	[curr_from] ASC
)
INCLUDE ( 	[rate_value]) 
WHERE ([curr_to]='USD')
WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
/****** Object:  Index [ix_expense_header_user_id]    Script Date: 1/15/2019 8:16:16 PM ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[expense_header]') AND name = N'ix_expense_header_user_id')
CREATE NONCLUSTERED INDEX [ix_expense_header_user_id] ON [dbo].[expense_header]
(
	[exp_user_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
/****** Object:  Index [ix_expense_line_header_id]    Script Date: 1/15/2019 8:16:16 PM ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[expense_line]') AND name = N'ix_expense_line_header_id')
CREATE NONCLUSTERED INDEX [ix_expense_line_header_id] ON [dbo].[expense_line]
(
	[exp_header_id] DESC
)
INCLUDE ( 	[currency_code],
	[local_amount],
	[created_date],
	[exp_line_date]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
/****** Object:  Index [ix_xalt_employee_user_id]    Script Date: 1/15/2019 8:16:16 PM ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[xalt_employee]') AND name = N'ix_xalt_employee_user_id')
CREATE NONCLUSTERED INDEX [ix_xalt_employee_user_id] ON [dbo].[xalt_employee]
(
	[extender_user_id] ASC
)
INCLUDE ( 	[employee_id],
	[first_name],
	[last_name],
	[manager_employee_id]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__catavolt___notif__17F790F9]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[catavolt_notification] ADD  CONSTRAINT [DF__catavolt___notif__17F790F9]  DEFAULT ('NEW') FOR [notification_status]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__catavolt___badge__18EBB532]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[catavolt_notification] ADD  CONSTRAINT [DF__catavolt___badge__18EBB532]  DEFAULT ((0)) FOR [badge_update_only]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__catavolt___manua__19DFD96B]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[catavolt_notification] ADD  CONSTRAINT [DF__catavolt___manua__19DFD96B]  DEFAULT ((0)) FOR [manual_completion]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__catavolt___num_r__1AD3FDA4]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[catavolt_notification] ADD  CONSTRAINT [DF__catavolt___num_r__1AD3FDA4]  DEFAULT ((0)) FOR [num_retries]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__catavolt___user___1F98B2C1]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[catavolt_notification_group_user] ADD  CONSTRAINT [DF__catavolt___user___1F98B2C1]  DEFAULT ((1)) FOR [user_status]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__catavolt___metho__236943A5]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[catavolt_notification_method] ADD  CONSTRAINT [DF__catavolt___metho__236943A5]  DEFAULT ((1)) FOR [method_status]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_acco__is_ac__49C3F6B7]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_account] ADD  CONSTRAINT [DF__xalt_acco__is_ac__49C3F6B7]  DEFAULT ((1)) FOR [is_active]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_acco__is_ac__778AC167]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_accounting_class] ADD  CONSTRAINT [DF__xalt_acco__is_ac__778AC167]  DEFAULT ((1)) FOR [is_active]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_f__day_o__619B8048]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_favorite] ADD  CONSTRAINT [DF__expense_f__day_o__619B8048]  DEFAULT ((1)) FOR [day_of_month]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_f__fixed__628FA481]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_favorite] ADD  CONSTRAINT [DF__expense_f__fixed__628FA481]  DEFAULT ((1)) FOR [fixed_amount]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_f__is_bi__6383C8BA]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_favorite] ADD  CONSTRAINT [DF__expense_f__is_bi__6383C8BA]  DEFAULT ((0)) FOR [is_billable]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_f__clien__6477ECF3]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_favorite] ADD  CONSTRAINT [DF__expense_f__clien__6477ECF3]  DEFAULT ((6)) FOR [client_id]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_f__proje__656C112C]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_favorite] ADD  CONSTRAINT [DF__expense_f__proje__656C112C]  DEFAULT ((31)) FOR [project_id]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_f__is_ac__66603565]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_favorite] ADD  CONSTRAINT [DF__expense_f__is_ac__66603565]  DEFAULT ((1)) FOR [is_active]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_h__exp_s__267ABA7A]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_header] ADD  CONSTRAINT [DF__expense_h__exp_s__267ABA7A]  DEFAULT ((1)) FOR [exp_status_id]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_h__is_ex__276EDEB3]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_header] ADD  CONSTRAINT [DF__expense_h__is_ex__276EDEB3]  DEFAULT ((0)) FOR [is_extracted]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_h__is_pa__286302EC]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_header] ADD  CONSTRAINT [DF__expense_h__is_pa__286302EC]  DEFAULT ((0)) FOR [is_paid]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_h__qb_is__29572725]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_header] ADD  CONSTRAINT [DF__expense_h__qb_is__29572725]  DEFAULT ((0)) FOR [qb_is_entered]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_h__is_in__2A4B4B5E]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_header] ADD  CONSTRAINT [DF__expense_h__is_in__2A4B4B5E]  DEFAULT ((0)) FOR [is_invoiced]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_expense_line_created_date]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_line] ADD  CONSTRAINT [DF_expense_line_created_date]  DEFAULT (getdate()) FOR [created_date]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_l__is_bi__2C3393D0]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_line] ADD  CONSTRAINT [DF__expense_l__is_bi__2C3393D0]  DEFAULT ((0)) FOR [is_billable]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_l__is_fa__2D27B809]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_line] ADD  CONSTRAINT [DF__expense_l__is_fa__2D27B809]  DEFAULT ((0)) FOR [is_favorite]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_s__allow__01142BA1]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_status] ADD  CONSTRAINT [DF__expense_s__allow__01142BA1]  DEFAULT ((1)) FOR [allow_edit]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_s__allow__02084FDA]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_status] ADD  CONSTRAINT [DF__expense_s__allow__02084FDA]  DEFAULT ((1)) FOR [allow_submit]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__expense_y__is_ac__37A5467C]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[expense_year] ADD  CONSTRAINT [DF__expense_y__is_ac__37A5467C]  DEFAULT ((1)) FOR [is_active]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_clie__in_in__4CA06362]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_client] ADD  CONSTRAINT [DF__xalt_clie__in_in__4CA06362]  DEFAULT ((0)) FOR [in_internal]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_empl__activ__108B795B]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_employee] ADD  CONSTRAINT [DF__xalt_empl__activ__108B795B]  DEFAULT ((1)) FOR [is_active]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_empl__fullt__117F9D94]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_employee] ADD  CONSTRAINT [DF__xalt_empl__fullt__117F9D94]  DEFAULT ((1)) FOR [is_full_time]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_empl__inter__1273C1CD]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_employee] ADD  CONSTRAINT [DF__xalt_empl__inter__1273C1CD]  DEFAULT ((0)) FOR [is_internal]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_empl__is_ma__1367E606]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_employee] ADD  CONSTRAINT [DF__xalt_empl__is_ma__1367E606]  DEFAULT ((0)) FOR [is_manager]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__is_in__4F7CD00D]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__is_in__4F7CD00D]  DEFAULT ((0)) FOR [is_internal]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__billi__5070F446]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__billi__5070F446]  DEFAULT ((5)) FOR [billing_type]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__total__5165187F]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__total__5165187F]  DEFAULT ((0)) FOR [total_billable_hours]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__this___52593CB8]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__this___52593CB8]  DEFAULT ((0)) FOR [this_month_billable_hours]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__quote__534D60F1]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__quote__534D60F1]  DEFAULT ((0)) FOR [quoted_hours]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__quote__5441852A]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__quote__5441852A]  DEFAULT ((0)) FOR [quoted_cost]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__hourl__5535A963]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__hourl__5535A963]  DEFAULT ((0)) FOR [hourly_rate]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__clien__5629CD9C]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__clien__5629CD9C]  DEFAULT ((0)) FOR [client_id]
END

GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF__xalt_proj__proje__571DF1D5]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[xalt_project] ADD  CONSTRAINT [DF__xalt_proj__proje__571DF1D5]  DEFAULT ((2)) FOR [project_status_id]
END

GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[fk_catavolt_notification_group_user_group]') AND parent_object_id = OBJECT_ID(N'[dbo].[catavolt_notification_group_user]'))
ALTER TABLE [dbo].[catavolt_notification_group_user]  WITH CHECK ADD  CONSTRAINT [fk_catavolt_notification_group_user_group] FOREIGN KEY([groupid])
REFERENCES [dbo].[catavolt_notification_group] ([groupid])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[fk_catavolt_notification_group_user_group]') AND parent_object_id = OBJECT_ID(N'[dbo].[catavolt_notification_group_user]'))
ALTER TABLE [dbo].[catavolt_notification_group_user] CHECK CONSTRAINT [fk_catavolt_notification_group_user_group]
GO
/****** Object:  StoredProcedure [dbo].[catavolt_notification_auto_complete]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[catavolt_notification_auto_complete]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[catavolt_notification_auto_complete] AS' 
END
GO

/****** Object:  StoredProcedure [dbo].[sp_expense_add_employee]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_add_employee]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_add_employee] AS' 
END
GO

ALTER PROCEDURE [dbo].[sp_expense_add_employee] (
	 @p_first_name NVARCHAR(50)
	,@p_last_name NVARCHAR(50)
	,@p_extender_user_id NVARCHAR(80)
	,@p_emp_email NVARCHAR(150)
	,@p_is_manager BIT
	,@p_manager_employee_id INTEGER
	,@p_is_active BIT
	,@p_is_full_time BIT
	,@p_is_internal BIT
	,@p_accounting_class_id INTEGER
	,@p_emp_type_id INTEGER
	,@p_emp_role_id INTEGER
	,@p_external_emp_id INTEGER
	,@p_errors NVARCHAR(2048) OUTPUT )
	
AS
DECLARE 
	@w_errors VARCHAR(2000) = ''
	,@w_user_id CHARACTER VARYING
	,@w_line_id INTEGER;

BEGIN

	-- edits:
	-- 1. first name cannot be blank
	-- 2. last name cannot be blank

	IF ( COALESCE( @p_first_name, '' ) = '' ) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>First name cannot be empty.</Text></Message>'
	END
	
	IF ( COALESCE( @p_last_name, '' ) = '' ) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Last name cannot be empty.</Text></Message>'
	END

	IF (@w_errors <> '')
	BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
	END ELSE BEGIN
		SET @p_errors = null;

		INSERT INTO xalt_employee(
	         first_name
	        ,last_name
	        ,extender_user_id
	        ,emp_email
	        ,is_manager
	        ,manager_employee_id
	        ,is_active
	        ,is_full_time
	        ,is_internal
	        ,accounting_class_id
	        ,emp_type_id
	        ,emp_role_id
	        ,external_emp_id
			)
		VALUES (
	         @p_first_name
	        ,@p_last_name
	        ,@p_extender_user_id
	        ,@p_emp_email
	        ,@p_is_manager
	        ,@p_manager_employee_id
	        ,@p_is_active
	        ,@p_is_full_time
	        ,@p_is_internal
	        ,@p_accounting_class_id
	        ,@p_emp_type_id
	        ,@p_emp_role_id
	        ,@p_external_emp_id
			)
		END

END
GO
/****** Object:  StoredProcedure [dbo].[sp_expense_header_delete]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_header_delete]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_header_delete] AS' 
END
GO
ALTER PROCEDURE [dbo].[sp_expense_header_delete] (
	@p_exp_header_id integer
	, @p_editor_id nvarchar(40)
	, @p_errors nvarchar(2048) OUTPUT )
AS

DECLARE 
	@w_errors nvarchar(2000) = ''
	,@w_status_id integer
	,@w_user_id nvarchar(80)

BEGIN

	-- retrieve report status
	-- error checking:
	--  * can only delete your own reports
	--  * report must not be in approved, extracted or paid status
	-- delete report (first lines, BEGIN header)

	SELECT 
		@w_status_id = exp_status_id
		,@w_user_id = exp_user_id
	from expense_header
	where 
		exp_header_id = @p_exp_header_id;

	if (@p_editor_id <> @w_user_id)  BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>You can only delete your own expense reports.</Text></Message>'
	END

	if (@w_status_id in (2,5,6)) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>You cannot delete approved, extracted or paid expense reports.</Text></Message>'
	END


	if (@w_errors <> '') BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
	END else BEGIN

		-- delete expense report lines
		delete from expense_line where exp_header_id = @p_exp_header_id;
		-- delete header
		delete from expense_header where exp_header_id = @p_exp_header_id;
		SET @p_errors = null;
	END
  
END
GO
/****** Object:  StoredProcedure [dbo].[sp_expense_header_extract]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_header_extract]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_header_extract] AS' 
END
GO


ALTER PROCEDURE [dbo].[sp_expense_header_extract] (
	@p_exp_header_id INTEGER
	,@p_editor_id NVARCHAR(40)
	,@p_errors NVARCHAR(2048) OUTPUT
	)
AS
DECLARE @w_errors VARCHAR(2048) = ''
	,@w_name NVARCHAR(40)
	,@w_user_id NVARCHAR(40)
	,@w_email NVARCHAR(150)
	,@w_subject NVARCHAR(150)
	,@w_body NVARCHAR(4000)
	,@w_amount DECIMAL(10, 2)
	,@w_reportdesc NVARCHAR(80)
	,@w_current_status_id integer

 BEGIN
 	select 
		@w_reportdesc = exp_header_desc
		,@w_current_status_id = exp_status_id
		,@w_amount = expense_header_logicals_vw.total_value_usd
		,@w_user_id = exp_user_id
	from expense_header 
	left join expense_header_logicals_vw
		on expense_header.exp_header_id = expense_header_logicals_vw.exp_header_id
	where 
		expense_header.exp_header_id = @p_exp_header_id


	-- report must be approved
	IF (@w_current_status_id not in (2)) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Only approved expense reports can be extracted.</Text></Message>'
	END


-- If errors exist, display, otherwise update header.
	IF (@w_errors <> '') BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
	END ELSE BEGIN
		UPDATE expense_header SET 
			exp_status_id = 5
			, extracted_date = CAST(CURRENT_TIMESTAMP AS DATE)
			, extracter_user_id = @p_editor_id
			, is_extracted = 1 
		WHERE 
			expense_header.exp_header_id = @p_exp_header_id;

		-- EMAIL NOTIFICATION
		select @w_name = full_name, @w_email = emp_email from xalt_employee where extender_user_id = @w_user_id;
		SET @w_subject = 'Your expense report has been extracted for payment';
		SET @w_body = @w_name + ', your expense report:''' + @w_reportdesc + ''' for the amount of $' 
		+ CAST(@w_amount as varchar(10)) + ' has been extracted for payment.';
		
		if (@w_user_id is not null) begin
			INSERT INTO dbo.catavolt_notification 
				(notification_type, notification_userid, notification_title, 
				notification_body, notification_body_formatted, notification_from_email, attachment_list) 
			VALUES 
				('MESSAGE', @w_user_id, @w_subject, 
				@w_body, @w_body, null, '');
		end
		-- END EMAIL NOTIFICATION
END

END
GO
/****** Object:  StoredProcedure [dbo].[sp_expense_header_insert]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_header_insert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_header_insert] AS' 
END
GO



ALTER procedure [dbo].[sp_expense_header_insert] (
	@p_exp_header_desc nvarchar(80)
	,@p_exp_text nvarchar(4000)
	,@p_exp_month integer
	,@p_exp_year integer
	,@p_editor_id nvarchar(80)
	,@p_errors nvarchar(2048) output)
as    

declare 
	@w_errors nvarchar(2048) = ''
	,@w_status_id integer
	,@w_user_id nvarchar(80)
	,@w_report_id integer
	,@w_employee_user_id integer
	,@w_manager_user_id integer;

begin

	if ((@p_editor_id is null) or (ltrim(rtrim(@p_editor_id)) = '')) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>You are not authorized to create expense reports.</Text></Message>';
	end ;

	select @w_employee_user_id = employee_id, @w_manager_user_id = manager_employee_id from xalt_employee where extender_user_id = @p_editor_id;
	if (@w_employee_user_id is null) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>Your account has not been configured to create expense reports.</Text></Message>';
	end else begin 
		if (@w_manager_user_id is null) begin
			set @w_errors = @w_errors + '<Message type=''error''><Text>Your account has not been configured to create expense reports.</Text></Message>';
		end ;
	end


	/* report description cannot be blank
	 report month and year must be selected */

	if ((@p_exp_header_desc is null) or (ltrim(rtrim(@p_exp_header_desc)) = '')) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>Report description cannot be blank.</Text></Message>';
	end ;

	if (@p_exp_month is null) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>You must select a report month.</Text></Message>';
	end;

	if (@p_exp_year is null) begin
		set @w_errors = @w_errors + '<Message type=''error''><Text>You must select a report year.</Text></Message>';
	end;

	if (@w_errors <> '') begin
		set @p_errors = '<Response>' + @w_errors + '</Response>';
	end else begin
		
		INSERT INTO expense_header (
			exp_header_desc
			,exp_user_id
			,exp_month
			,exp_year
			,created_date
			,exp_status_id
			,exp_text
			)
		VALUES (
			(@p_exp_header_desc + ':' + cast(@p_exp_year as nvarchar(4)) + '/' + cast(@p_exp_month as nvarchar(2)))
			,@p_editor_id
			,@p_exp_month
			,@p_exp_year
			,CURRENT_TIMESTAMP
			,0
			,@p_exp_text
			);
		set @w_report_id = SCOPE_IDENTITY();


		set @p_errors = '<Response><SetSessionProperty><SessionProperty name=''S_expheaderid''><Value>' 
			+ cast(@w_report_id as nvarchar(6)) 
			+ '</Value></SessionProperty></SetSessionProperty></Response>';
	end;
end;
  
GO
/****** Object:  StoredProcedure [dbo].[sp_expense_header_pay]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_header_pay]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_header_pay] AS' 
END
GO

ALTER PROCEDURE [dbo].[sp_expense_header_pay] 
	@p_exp_header_id INTEGER
	,@p_paid_date DATE
	,@p_editor_id VARCHAR(40)
	,@p_errors NVARCHAR(2048) OUTPUT
AS
DECLARE @w_errors VARCHAR(2048) = ''
	,@w_name NVARCHAR(40)
	,@w_user_id NVARCHAR(40)
	,@w_subject NVARCHAR(150)
	,@w_body NVARCHAR(4000)
	,@w_amount DECIMAL(10, 2)
	,@w_reportdesc NVARCHAR(80)
	,@w_current_status_id integer


 BEGIN

	select 
		@w_reportdesc = exp_header_desc
		,@w_current_status_id = exp_status_id
		,@w_amount = expense_header_logicals_vw.total_value_usd
		,@w_user_id = exp_user_id
	from expense_header 
	left join expense_header_logicals_vw
		on expense_header.exp_header_id = expense_header_logicals_vw.exp_header_id
	where 
		expense_header.exp_header_id = @p_exp_header_id
 
	-- report must be extracted
	IF (@w_current_status_id not in (5)) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Only extracted expense reports can be marked as paid.</Text></Message>'
	END

	-- pay date must be entered
	IF (@p_paid_date is null) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>You must provide a paid date.</Text></Message>'
	END
 
-- If errors exist, display, otherwise update header.
	if (@w_errors <> '') begin
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
	end else begin
		update expense_header set 
			exp_status_id = 6
			,paid_date = @p_paid_date
			,payer_user_id = @p_editor_id
		where expense_header.exp_header_id = @p_exp_header_id

		
		-- EMAIL NOTIFICATION
		SET @w_name = (SELECT full_name FROM xalt_employee WHERE extender_user_id = @w_user_id) ;

		SET @w_subject = 'Your expense report has been paid'
		SET @w_body = @w_name + ', your expense report:''' + @w_reportdesc + ''' for the amount of $' 
		+ CAST(@w_amount as varchar(10)) + ' has been paid on ' + CAST(@p_paid_date as varchar(12)) 
		begin try 
			if (@w_user_id is not null) begin
				INSERT INTO dbo.catavolt_notification 
					(notification_type, notification_userid, notification_title, 
					notification_body, notification_body_formatted, notification_from_email, attachment_list) 
				VALUES 
					('MESSAGE', @w_user_id, @w_subject, 
					@w_body, @w_body, null, '');
			end
		end try
		begin catch
		end catch 
	-- END EMAIL NOTIFICATION
	END

END
GO
/****** Object:  StoredProcedure [dbo].[sp_expense_header_set_qbstatus]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_header_set_qbstatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_header_set_qbstatus] AS' 
END
GO
ALTER PROCEDURE [dbo].[sp_expense_header_set_qbstatus] (
	@p_exp_header_id INTEGER
	,@qb_status_id integer
	,@qb_payroll_date_id integer
	
	,@p_current_user VARCHAR(40)
	,@p_errors NVARCHAR(2048) OUTPUT )
AS
	DECLARE @w_errors VARCHAR(2048) = ''
		,@w_current_status_id integer
		,@w_current_entered_status integer
	

 BEGIN

	select 
		@w_current_status_id = exp_status_id
		,@w_current_entered_status = qb_is_entered
	from expense_header 
	left join expense_header_logicals_vw
		on expense_header.exp_header_id = expense_header_logicals_vw.exp_header_id
	where 
		expense_header.exp_header_id = @p_exp_header_id
 
	 -- report that is set to be extracted for QB must be in extracted or paid status
	 IF ((@w_current_status_id not in (5,6)) and (@qb_status_id = 1)) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Only extracted or paid expense reports can be marked as ready to extract to QuickBooks.</Text></Message>'
	 END

	IF ((@qb_status_id = 1) and (@qb_payroll_date_id is null)) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>You must enter a Payroll date.</Text></Message>';
	END
	 
	-- If errors exist, display, otherwise update header.
	IF (@w_errors <> '') BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
		END
	IF @w_errors = '' BEGIN
		
		UPDATE 
			expense_header
		SET 
			qb_status_id = @qb_status_id
			,qb_payroll_date_id = @qb_payroll_date_id
		WHERE 
			expense_header.exp_header_id = @p_exp_header_id
			
		SET @p_errors = null;
	END

END
GO
/****** Object:  StoredProcedure [dbo].[sp_expense_header_submit]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_header_submit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_header_submit] AS' 
END
GO


ALTER PROCEDURE [dbo].[sp_expense_header_submit] (
	@p_exp_header_id INTEGER
	,@p_new_status_id INTEGER
	,@p_editor_id VARCHAR(40)
	,@p_errors NVARCHAR(2048) OUTPUT ) AS

DECLARE @w_errors VARCHAR(2048) = ''
	,@w_name NVARCHAR(40)
	,@w_notification_user_id NVARCHAR(150)
	,@w_subject NVARCHAR(150)
	,@w_body NVARCHAR(4000)
	,@w_amount DECIMAL(10, 2)
	,@w_reportdesc NVARCHAR(80)
	,@w_current_status_id integer
	,@w_exp_extender_user_id nvarchar(80)
	,@w_manager_extender_user_id nvarchar(80)

/* this function is only called when an expense report is submitted, approved or rejected
 so any code for @p_new_status_id = 5 or 6 should never be executed */

BEGIN

	select 
		@w_reportdesc = exp_header_desc
		,@w_current_status_id = exp_status_id
		,@w_amount = expense_header_logicals_vw.total_value_usd
		,@w_manager_extender_user_id = manager_extender_user_id
		,@w_exp_extender_user_id = exp_user_id
	from expense_header 
	left join expense_header_logicals_vw
		on expense_header.exp_header_id = expense_header_logicals_vw.exp_header_id
	where 
		expense_header.exp_header_id = @p_exp_header_id
	


	IF (@w_current_status_id in (5,6)) BEGIN
		SET   @w_errors = @w_errors + '<Message type=''error''><Text>Extracted or paid expense reports cannot be altered.</Text></Message>'
	END

	-- Submission of new or previously rejected report
	IF @p_new_status_id = 1 BEGIN
		IF (@w_current_status_id not in (0,3)) BEGIN
			SET   @w_errors = @w_errors + '<Message type=''error''><Text>Only created or previously rejected expense reports can be submitted.</Text></Message>'
		END
		IF((SELECT count(*) FROM expense_line where expense_line.exp_header_id = @p_exp_header_id) = 0 ) BEGIN
			SET    @w_errors = @w_errors + '<Message type=''error''><Text>No report details found, report cannot be submitted.</Text></Message>'
		END
		IF ( @p_editor_id <> @w_exp_extender_user_id)  BEGIN
			SET    @w_errors = @w_errors + '<Message type=''error''><Text>You can only submit your own expense reports.</Text></Message>'
		END
	--  ELSE @p_approver =  null 
	END
 
--END

	-- Approval/Rejection
	IF @p_new_status_id in (2,3) BEGIN
		IF (@w_current_status_id <> 1) BEGIN
			SET    @w_errors = @w_errors + '<Message type=''error''><Text>Only submitted expense reports can be approved or rejected.</Text></Message>'
		END
		IF (@w_current_status_id = 1) BEGIN
			IF (@p_editor_id <> @w_manager_extender_user_id) BEGIN 
				SET    @w_errors = @w_errors + '<Message type=''error''><Text>Only the manager can approve reports.</Text></Message>'
			END
		END
	END  

-- Extraction for Payment
  IF @p_new_status_id in (5) BEGIN
	SET  @w_errors = @w_errors + '<Message type=''error''><Text>You cannot mark the expense report as extracted for payment from this view.</Text></Message>'
  END

-- Mark as paid
	IF @p_new_status_id in (6) BEGIN
		SET    @w_errors = @w_errors + '<Message type=''error''><Text>You cannot mark the expense report as paid from this view.</Text></Message>'
	END


/* If errors exist, display, otherwise update header. */
	IF (@w_errors <> '') BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
	END else BEGIN 
	   SET  @p_errors = null; 
	
		-- submitted
		IF @p_new_status_id = 1
		BEGIN
			UPDATE expense_header
			SET exp_status_id = @p_new_status_id
				,submit_date = CAST(CURRENT_TIMESTAMP AS DATE)
				,approved_date = NULL
				,rejected_date = NULL
				,approver_user_id = @w_manager_extender_user_id
			WHERE expense_header.exp_header_id = @p_exp_header_id

			-- EMAIL NOTIFICATION
			SET @w_name = (
					SELECT full_name
					FROM xalt_employee
					WHERE extender_user_id = @p_editor_id
					)
			SET @w_notification_user_id = @w_manager_extender_user_id;
			SET @w_subject = 'An expense report has been submitted for your approval'
			SET @w_body = @w_name + ' has submitted an expense report with description ''' + @w_reportdesc + ''' for the amount of $' + CAST(@w_amount AS VARCHAR(10)) + ' for your approval.'

			-- END EMAIL NOTIFICATION
		END

		-- approved
		IF @p_new_status_id = 2
		BEGIN
			UPDATE expense_header
			SET exp_status_id = @p_new_status_id
				,approved_date = current_timestamp
				,approver_user_id = @p_editor_id
			WHERE expense_header.exp_header_id = @p_exp_header_id

			-- EMAIL NOTIFICATION
			SET @w_name = (
					SELECT full_name
					FROM xalt_employee
					WHERE extender_user_id = @w_exp_extender_user_id
					)
			SET @w_notification_user_id = @w_exp_extender_user_id;
			SET @w_subject = 'Your expense report has been approved'
			SET @w_body = @w_name + ', your expense report:''' + @w_reportdesc + ''' for the amount of $' + CAST(@w_amount AS VARCHAR(10)) + ' has been approved.'

			-- END EMAIL NOTIFICATION
		END

		-- rejected
		IF @p_new_status_id = 3
		BEGIN
			UPDATE expense_header
			SET exp_status_id = @p_new_status_id
				,approved_date = NULL
				,approver_user_id = @p_editor_id
				,rejected_date = CURRENT_TIMESTAMP
			WHERE expense_header.exp_header_id = @p_exp_header_id

			-- EMAIL NOTIFICATION
			SET @w_name = (
					SELECT full_name
					FROM xalt_employee
					WHERE extender_user_id = @w_exp_extender_user_id
					)
			SET @w_notification_user_id = @w_exp_extender_user_id;
			SET @w_subject = 'Your expense report has been rejected'
			SET @w_body = @w_name + ', your expense report:''' + @w_reportdesc + ''' for the amount of $' + CAST(@w_amount AS VARCHAR(10)) + ' has been rejected. Please correct any errors and resubmit.'
			-- END EMAIL NOTIFICATION
		END

		begin try 
			if (@p_new_status_id in (1,2,3) and (@w_notification_user_id is not null) ) begin 
				 INSERT INTO dbo.catavolt_notification 
				(notification_type, notification_userid, notification_title, 
				notification_body, notification_body_formatted, notification_from_email, attachment_list) 
			VALUES 
				('MESSAGE', @w_notification_user_id, @w_subject, 
				@w_body, @w_body, null, '');
			end
		end try
		begin catch
		end catch 
--END
	END			
END


GO
/****** Object:  StoredProcedure [dbo].[sp_expense_header_toggle_qb]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_header_toggle_qb]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_header_toggle_qb] AS' 
END
GO
ALTER PROCEDURE [dbo].[sp_expense_header_toggle_qb] (
	@p_exp_header_id INTEGER
	,@p_current_user VARCHAR(40)
	,@p_errors NVARCHAR(2048) OUTPUT )
AS
	DECLARE @w_errors VARCHAR(2048) = ''
		,@w_current_status_id integer
		,@w_current_entered_status integer
	

 BEGIN

	select 
		@w_current_status_id = exp_status_id
		,@w_current_entered_status = qb_is_entered
	from expense_header 
	left join expense_header_logicals_vw
		on expense_header.exp_header_id = expense_header_logicals_vw.exp_header_id
	where 
		expense_header.exp_header_id = @p_exp_header_id
 
	 -- report must be extracted
	 IF ((@w_current_status_id not in (2,5,6)) and (@w_current_entered_status = 0))
	  BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Only approved, extracted or paid expense reports can be marked as entered in QuickBooks.</Text></Message>'
	 END
	 
	-- If errors exist, display, otherwise update header.
	IF (@w_errors <> '') BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
		END
	IF @w_errors = '' BEGIN
		UPDATE 
			expense_header
		SET 
			qb_is_entered = case when qb_is_entered = 1 then 0 else 1 end
		WHERE 
			expense_header.exp_header_id = @p_exp_header_id
	END

END
GO
/****** Object:  StoredProcedure [dbo].[sp_expense_line_insert]    Script Date: 1/15/2019 8:16:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_expense_line_insert]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[sp_expense_line_insert] AS' 
END
GO
ALTER PROCEDURE [dbo].[sp_expense_line_insert] (
	@p_exp_header_id INTEGER
	,@p_exp_line_desc NVARCHAR(80)
	,@p_exp_line_date DATE
	,@p_currency_code NVARCHAR(3)
	,@p_local_amount DECIMAL(12, 2)
	,@p_billable INT
	,@p_client_id INTEGER
	,@p_project_id INTEGER
	,@p_account_id INTEGER
	,@P_accounting_class_override integer
	,@p_editor_id NVARCHAR(80)
	,@p_errors NVARCHAR(2048) OUTPUT )
	
AS
DECLARE 
	@w_errors VARCHAR(2000) = ''
	,@w_user_id CHARACTER VARYING
	,@w_line_id INTEGER;


	-- edits:
	-- 1. expense report must be in created status
	-- 2. expense date must be in the same month as the report month
	-- 3. expense description, amount and account must be entered
	IF ( (SELECT exp_status_id FROM expense_header WHERE exp_header_id= @p_exp_header_id) NOT IN (0,3) ) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Expense lines can only be added if the expense report has not yet been submitted or if the report was previously rejected.</Text></Message>'
	END

	if ((select [exp_month] from expense_header where exp_header_id = @p_exp_header_id) <> MONTH(@p_exp_line_date)) BEGIN 
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Date of the expense must be in the same month as the report.</Text></Message>'
	end

	IF ((@p_exp_line_desc IS NULL) OR (LTRIM(RTRIM(@p_exp_line_desc)) = '')) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>You must provide an expense description.</Text></Message>'
	END

	if ((@p_local_amount is null) or (@p_local_amount = 0)) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>Expense amount cannot be 0.</Text></Message>'
	END
	
	IF ((@p_account_id IS NULL)OR (@p_account_id = 0)) BEGIN
		SET @w_errors = @w_errors + '<Message type=''error''><Text>You must select an expense type.</Text></Message>'
	END

	IF (@w_errors <> '')
	BEGIN
		SET @p_errors = '<Response>' + @w_errors + '</Response>'
	END ELSE BEGIN
		SET @p_errors = null;

		INSERT INTO expense_line(
			exp_line_desc
			,exp_header_id
			,created_user_id
			,exp_line_date
			,currency_code
			,local_amount
			,created_date
			,is_billable
			,client_id
			,project_id
			,account_id
			,accounting_class_override
			)
		VALUES (
			@p_exp_line_desc
			,@p_exp_header_id
			,@p_editor_id
			,@p_exp_line_date
			,@p_currency_code
			,@p_local_amount
			,getdate()
			,@p_billable
			,@p_client_id
			,@p_project_id
			,@p_account_id
			,@P_accounting_class_override
			)

		SET @w_line_id = SCOPE_IDENTITY()

		RETURN @w_line_id

		
		SET @p_errors = '<SetSessionProperty><SessionProperty name=''S_expense_billable''><Value>' + coalesce(@p_billable, '') + '</Value></SessionProperty></SetSessionProperty>'
		SET @p_errors = @p_errors + '<SetSessionProperty><SessionProperty name=''S_expense_client_id''><Value>' + coalesce(@p_client_id, '') + '</Value></SessionProperty></SetSessionProperty>'
		SET @p_errors = @p_errors + '<SetSessionProperty><SessionProperty name=''S_expense_project_id''><Value>' + coalesce(@p_project_id, '') + '</Value></SessionProperty></SetSessionProperty>'
		SET @p_errors = @p_errors + '<SetSessionProperty><SessionProperty name=''S_expense_exp_date''><Value>' + CAST(@p_exp_line_date AS NVARCHAR) + '</Value></SessionProperty></SetSessionProperty>'
		SET @p_errors = @p_errors + '<SetSessionProperty><SessionProperty name=''S_expense_account_id''><Value>' + coalesce(@p_account_id, '') + '</Value></SessionProperty></SetSessionProperty>'
		SET @p_errors = @p_errors + '<SetSessionProperty><SessionProperty name=''S_expense_accounting_class_override''><Value>' + coalesce(@P_accounting_class_override, '') + '</Value></SessionProperty></SetSessionProperty>'
		SET @p_errors = '<Response>' + @p_errors + '</Response>'
END

GO
